Attribute VB_Name = "mdDrawDiametricDimension"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.



Function DrawDiametricDimension(Design, drawdoc, graph)

'Get the ProDESKTOP Application object
GetApplicationObject

'Get the Drawing Object pointer
Dim draw As aDrawing
Set draw = drawdoc.GetDrawing

Dim ddetail As aDesignDetail
Set ddetail = draw.GetDetail(Design, False)

' Get the paper geometry corresponding to the first selected item
Dim geom1 As zGeometry
Set geom1 = drawdoc.GetPaperGeometry(graph)
Dim original As zGeometry
Set original = geom1.GetOriginal

'get the design instance
Dim view1 As aHiddenLine
Set view1 = geom1.GetInstance

Dim dimension As aDimension
Set dimension = app.GetClass("Dimension").CreateDimension(ddetail, 3, original)
    
'Set the position for the dimension line
Dim position As ZVector
Set position = app.GetClass("Vector").CreateVector(0.001, 0.001, 0)
    
' Create the linear dimension line
Dim DiaDim As Object
Set DiaDim = app.GetClass("RadialDimLine").CreateRadialDimLine(position, dimension, view1)
Dim tolerance As aDimTol
Set tolerance = app.GetClass("DimTol").CreateDimTol(ddetail, dimension)

Dim Callout As aCallout
Set Callout = app.GetClass("DimensionCallout").CreateDimensionCallout(tolerance)

Dim text As aDimLineText
Dim vector As ZVector
Set text = app.GetClass("DimLineText").CreateDimLineText(DiaDim, Callout, position, 0.0035)

'1 is for the topCenter
text.SetControlPoint 1, position
   
'Add the dimension line to the drawing.
draw.AddDimLine DiaDim

'Add CenterLine
'To be done



End Function

